<?php
// Baris ini memuat semua fungsi penting dari db.php
require_once __DIR__ . '/db.php'; 
?>
<!DOCTYPE html>
<html lang="id">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>E-Course Platform</title>
    <script src="https://cdn.tailwindcss.com"></script>
    <script src="https://cdn.jsdelivr.net/npm/sortablejs@latest/Sortable.min.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/chart.js"></script>
    <style>
        body { background-color: #f7fafc; }
        .drag-handle { cursor: grab; }
        .drag-handle:active { cursor: grabbing; }
        .sortable-ghost { background-color: #cceeff; }
        .hidden { display: none; }
    </style>
</head>
<body class="bg-gray-100">
    <header class="bg-white shadow-md">
        <nav class="container mx-auto px-6 py-4 flex justify-between items-center">
            <div>
                <a href="/" class="text-2xl font-bold text-gray-800">E-Course</a>
            </div>
            <div class="flex space-x-4 items-center">
                <?php if (isset($_SESSION['user_id'])): ?>
                    <a href="/dashboard.php" class="text-gray-600 hover:text-blue-500">Dashboard</a>
                    <?php if ($_SESSION['role'] === 'admin'): ?>
                        <a href="/admin" class="text-gray-600 hover:text-blue-500">Admin Panel</a>
                    <?php endif; ?>
                    <a href="/auth/logout.php" class="text-gray-600 hover:text-blue-500">Logout</a>
                <?php else: ?>
                    <a href="/auth/login.php" class="text-gray-600 hover:text-blue-500">Login</a>
                    <a href="/auth/register.php" class="bg-blue-500 text-white px-4 py-2 rounded-md hover:bg-blue-600">Register</a>
                <?php endif; ?>
            </div>
        </nav>
    </header>