<?php
require_once '../includes/header.php';

if (!isset($_SESSION['user_id'])) { header('Location: /auth/login.php'); exit; }
$attempt_id = $_GET['attempt_id'] ?? null;
if (!$attempt_id) { header('Location: /dashboard.php'); exit; }

$stmt = $pdo->prepare("SELECT * FROM quiz_attempts WHERE id = ? AND user_id = ?");
$stmt->execute([$attempt_id, $_SESSION['user_id']]);
$result = $stmt->fetch();
?>
<main class="container mx-auto p-4 md:p-8">
    <div class="bg-white rounded-xl shadow-lg p-8 text-center">
        <h1 class="text-3xl font-bold text-gray-800 mb-4">Hasil Kuis</h1>
        <p class="text-lg text-gray-600 mb-8">Anda telah menyelesaikan kuis.</p>
        <div class="text-6xl font-bold text-blue-500 mb-8"><?= round($result['score']) ?>%</div>
        <a href="/dashboard.php" class="px-8 py-4 font-semibold text-white bg-blue-500 rounded-lg hover:bg-blue-600">Kembali ke Dashboard</a>
    </div>
</main>
<?php require_once '../includes/footer.php'; ?>