<?php
require_once '../includes/header.php';

if (!isset($_SESSION['user_id'])) { header('Location: /auth/login.php'); exit; }
$user_id = $_SESSION['user_id'];
$course_id = $_GET['course_id'] ?? null;
if (!$course_id) { header('Location: /dashboard.php'); exit; }

// --- LOGIKA HAK AKSES ---
$access_stmt = $pdo->prepare("SELECT id FROM orders WHERE user_id = ? AND course_id = ? AND status = 'completed'");
$access_stmt->execute([$user_id, $course_id]);
if (!$access_stmt->fetch()) {
    die("Akses ditolak. Anda belum terdaftar di kursus ini.");
}
// --- AKHIR LOGIKA HAK AKSES ---

// Ambil info kuis
$quiz_stmt = $pdo->prepare("SELECT * FROM quizzes WHERE course_id = ?");
$quiz_stmt->execute([$course_id]);
$quiz = $quiz_stmt->fetch();
if (!$quiz) {
    echo "<main class='container mx-auto p-8'><div class='bg-yellow-100 p-4 rounded-lg text-yellow-800'>Tidak ada kuis untuk kursus ini.</div></main>";
    require_once '../includes/footer.php';
    exit;
}

// Ambil pertanyaan dan opsi
$questions_stmt = $pdo->prepare("
    SELECT q.id as question_id, q.question_text, o.id as option_id, o.option_text
    FROM questions q
    JOIN options o ON q.id = o.question_id
    WHERE q.quiz_id = ?
");
$questions_stmt->execute([$quiz['id']]);
$results = $questions_stmt->fetchAll();

$questions = [];
foreach ($results as $row) {
    $questions[$row['question_id']]['question_text'] = $row['question_text'];
    $questions[$row['question_id']]['options'][] = [
        'id' => $row['option_id'],
        'text' => $row['option_text']
    ];
}
?>
<main class="container mx-auto p-4 md:p-8">
    <div class="bg-white rounded-xl shadow-lg p-6 md:p-8">
        <h1 class="text-3xl font-bold text-gray-800 mb-2"><?= e($quiz['title']) ?></h1>
        <p class="text-gray-600 mb-8">Jawab semua pertanyaan di bawah ini.</p>

        <?php if (empty($questions)): ?>
            <p class="text-gray-500">Admin belum menambahkan pertanyaan untuk kuis ini.</p>
        <?php else: ?>
            <form action="submit_quiz.php" method="POST">
                <input type="hidden" name="csrf_token" value="<?= e(generate_csrf_token()); ?>">
                <input type="hidden" name="quiz_id" value="<?= $quiz['id'] ?>">
                <input type="hidden" name="course_id" value="<?= $course_id ?>">

                <?php $question_number = 1; foreach ($questions as $qid => $qdata): ?>
                <div class="mb-8 border-b pb-8">
                    <p class="font-semibold text-lg mb-4"><?= $question_number++ ?>. <?= e($qdata['question_text']) ?></p>
                    <div class="space-y-2">
                        <?php foreach ($qdata['options'] as $option): ?>
                        <label class="flex items-center p-3 border rounded-lg hover:bg-gray-100 cursor-pointer">
                            <input type="radio" name="answers[<?= $qid ?>]" value="<?= $option['id'] ?>" class="mr-3" required>
                            <span><?= e($option['text']) ?></span>
                        </label>
                        <?php endforeach; ?>
                    </div>
                </div>
                <?php endforeach; ?>
                <button type="submit" class="w-full px-6 py-4 font-semibold text-white bg-green-500 rounded-lg hover:bg-green-600">Selesaikan Kuis</button>
            </form>
        <?php endif; ?>
    </div>
</main>
<?php require_once '../includes/footer.php'; ?>