<?php
require_once '../includes/header.php';

if (isset($_SESSION['user_id'])) {
    header("Location: /dashboard.php");
    exit;
}

$error = '';

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    check_csrf(); // Verifikasi token keamanan

    $username = $_POST['username'];
    $password = $_POST['password'];

    if (empty($username) || empty($password)) {
        $error = "Username dan password tidak boleh kosong!";
    } else {
        $stmt = $pdo->prepare("SELECT id FROM users WHERE username = ?");
        $stmt->execute([$username]);
        if ($stmt->fetch()) {
            $error = "Username sudah digunakan!";
        } else {
            $hashed_password = password_hash($password, PASSWORD_DEFAULT);
            $role = defined('NO_ADMIN_EXISTS') && NO_ADMIN_EXISTS ? 'admin' : 'user';
            $stmt = $pdo->prepare("INSERT INTO users (username, password, role) VALUES (?, ?, ?)");
            if ($stmt->execute([$username, $hashed_password, $role])) {
                header("Location: login.php?status=registered");
                exit;
            } else {
                $error = "Registrasi gagal, coba lagi.";
            }
        }
    }
}
?>
<div class="flex items-center justify-center min-h-screen bg-gray-100">
    <div class="w-full max-w-md p-8 space-y-6 bg-white rounded-xl shadow-lg">
        <h2 class="text-3xl font-bold text-center text-gray-800">Buat Akun Baru</h2>
        
        <?php if (!empty($error)): ?>
            <div class="bg-red-100 border border-red-400 text-red-700 px-4 py-3 rounded-lg" role="alert">
                <?= e($error) ?>
            </div>
        <?php endif; ?>

        <form action="register.php" method="POST" class="space-y-6">
            <input type="hidden" name="csrf_token" value="<?= e(generate_csrf_token()); ?>">
            <div>
                <label for="username" class="text-sm font-semibold text-gray-600 block">Username</label>
                <input type="text" name="username" id="username" class="w-full px-4 py-2 mt-2 border border-gray-300 rounded-lg focus:outline-none focus:ring-2 focus:ring-blue-500" required>
            </div>
            <div>
                <label for="password" class="text-sm font-semibold text-gray-600 block">Password</label>
                <input type="password" name="password" id="password" class="w-full px-4 py-2 mt-2 border border-gray-300 rounded-lg focus:outline-none focus:ring-2 focus:ring-blue-500" required>
            </div>
            <div>
                <button type="submit" class="w-full px-4 py-3 font-semibold text-white bg-blue-500 rounded-lg hover:bg-blue-600 focus:outline-none focus:ring-2 focus:ring-offset-2 focus:ring-blue-500 transition duration-300">
                    Register
                </button>
            </div>
        </form>
         <p class="text-sm text-center text-gray-600">
            Sudah punya akun? <a href="login.php" class="font-semibold text-blue-500 hover:underline">Login di sini</a>
        </p>
    </div>
</div>