<?php
require_once '../includes/header.php';

if (isset($_SESSION['user_id'])) {
    header("Location: /dashboard.php");
    exit;
}

$error = '';

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    check_csrf(); // Verifikasi token keamanan
    
    $username = $_POST['username'];
    $password = $_POST['password'];

    $stmt = $pdo->prepare("SELECT * FROM users WHERE username = ?");
    $stmt->execute([$username]);
    $user = $stmt->fetch();

    if ($user && password_verify($password, $user['password'])) {
        // Buat ID sesi baru untuk mencegah session fixation
        session_regenerate_id(true); 
        
        $_SESSION['user_id'] = $user['id'];
        $_SESSION['username'] = $user['username'];
        $_SESSION['role'] = $user['role'];
        header("Location: /dashboard.php");
        exit;
    } else {
        $error = "Username atau password salah!";
    }
}
?>
<div class="flex items-center justify-center min-h-screen bg-gray-100">
    <div class="w-full max-w-md p-8 space-y-6 bg-white rounded-xl shadow-lg">
        <h2 class="text-3xl font-bold text-center text-gray-800">Login Akun</h2>
        
        <?php if (isset($_GET['status']) && $_GET['status'] == 'registered'): ?>
            <div class="bg-green-100 border border-green-400 text-green-700 px-4 py-3 rounded-lg" role="alert">
                Registrasi berhasil! Silakan login.
            </div>
        <?php endif; ?>
        <?php if (!empty($error)): ?>
            <div class="bg-red-100 border border-red-400 text-red-700 px-4 py-3 rounded-lg" role="alert">
                <?= e($error) ?>
            </div>
        <?php endif; ?>

        <form action="login.php" method="POST" class="space-y-6">
            <input type="hidden" name="csrf_token" value="<?= e(generate_csrf_token()); ?>">
            <div>
                <label for="username" class="text-sm font-semibold text-gray-600 block">Username</label>
                <input type="text" name="username" id="username" class="w-full px-4 py-2 mt-2 border border-gray-300 rounded-lg focus:outline-none focus:ring-2 focus:ring-blue-500" required>
            </div>
            <div>
                <label for="password" class="text-sm font-semibold text-gray-600 block">Password</label>
                <input type="password" name="password" id="password" class="w-full px-4 py-2 mt-2 border border-gray-300 rounded-lg focus:outline-none focus:ring-2 focus:ring-blue-500" required>
            </div>
            <div>
                <button type="submit" class="w-full px-4 py-3 font-semibold text-white bg-blue-500 rounded-lg hover:bg-blue-600 focus:outline-none focus:ring-2 focus:ring-offset-2 focus:ring-blue-500 transition duration-300">
                    Login
                </button>
            </div>
        </form>
        <p class="text-sm text-center text-gray-600">
            Belum punya akun? <a href="register.php" class="font-semibold text-blue-500 hover:underline">Daftar di sini</a>
        </p>
    </div>
</div>