<?php
require_once '../includes/header.php';

if (!isset($_SESSION['user_id']) || $_SESSION['role'] !== 'admin') {
    header('Location: /dashboard.php');
    exit;
}

$course_id = $_GET['course_id'] ?? null;
if (!$course_id) { header('Location: admin/manage_courses.php'); exit; }

// Cek apakah sudah ada kuis untuk kursus ini
$quiz_stmt = $pdo->prepare("SELECT * FROM quizzes WHERE course_id = ?");
$quiz_stmt->execute([$course_id]);
$quiz = $quiz_stmt->fetch();

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    check_csrf();
    if (!$quiz) { // Jika belum ada kuis, buat baru
        $title = "Kuis Akhir"; // Judul default
        $insert_quiz_stmt = $pdo->prepare("INSERT INTO quizzes (course_id, title) VALUES (?, ?)");
        $insert_quiz_stmt->execute([$course_id, $title]);
        header("Location: manage_quiz.php?course_id=$course_id"); // Refresh halaman
        exit;
    }
}

// Ambil semua pertanyaan untuk kuis ini
$questions = [];
if ($quiz) {
    $questions_stmt = $pdo->prepare("SELECT * FROM questions WHERE quiz_id = ?");
    $questions_stmt->execute([$quiz['id']]);
    $questions = $questions_stmt->fetchAll();
}
?>
<main class="container mx-auto p-4 md:p-8">
    <a href="manage_courses.php" class="text-blue-500 font-semibold hover:underline mb-6 inline-block">&larr; Kembali ke Kelola Kursus</a>
    <h1 class="text-3xl font-bold text-gray-800 mb-8">Kelola Kuis</h1>

    <?php if (!$quiz): ?>
        <div class="bg-white p-8 rounded-xl shadow-lg text-center">
            <p class="text-gray-600 mb-4">Belum ada kuis untuk kursus ini.</p>
            <form method="POST">
                <input type="hidden" name="csrf_token" value="<?= e(generate_csrf_token()); ?>">
                <button type="submit" class="px-6 py-3 font-semibold text-white bg-blue-500 rounded-lg hover:bg-blue-600">Buat Kuis Sekarang</button>
            </form>
        </div>
    <?php else: ?>
        <div class="bg-white p-8 rounded-xl shadow-lg mb-10">
            <h2 class="text-2xl font-bold text-gray-800 mb-6">Tambah Pertanyaan Baru</h2>
            <form action="add_question.php" method="POST">
                <input type="hidden" name="csrf_token" value="<?= e(generate_csrf_token()); ?>">
                <input type="hidden" name="quiz_id" value="<?= $quiz['id'] ?>">
                <input type="hidden" name="course_id" value="<?= $course_id ?>">
                <div class="mb-4">
                    <label for="question_text" class="text-sm font-semibold text-gray-600 block">Teks Pertanyaan</label>
                    <textarea name="question_text" id="question_text" rows="3" class="w-full px-4 py-2 mt-2 border rounded-lg" required></textarea>
                </div>
                <?php for ($i = 1; $i <= 4; $i++): ?>
                <div class="mb-4">
                    <label for="option_<?= $i ?>" class="text-sm font-semibold text-gray-600 block">Opsi <?= $i ?></label>
                    <div class="flex items-center mt-2">
                        <input type="text" name="options[]" id="option_<?= $i ?>" class="w-full px-4 py-2 border rounded-lg" required>
                        <input type="radio" name="correct_option" value="<?= $i-1 ?>" class="ml-4" required>
                        <span class="ml-2 text-sm">Jawaban Benar</span>
                    </div>
                </div>
                <?php endfor; ?>
                <button type="submit" class="px-6 py-3 font-semibold text-white bg-blue-500 rounded-lg hover:bg-blue-600">Tambah Pertanyaan</button>
            </form>
        </div>

        <div class="bg-white rounded-xl shadow-lg p-8">
            <h2 class="text-2xl font-bold text-gray-800 mb-6">Daftar Pertanyaan</h2>
            <?php foreach ($questions as $question): ?>
                <div class="border-b pb-4 mb-4">
                    <p class="font-semibold"><?= e($question['question_text']) ?></p>
                    </div>
            <?php endforeach; ?>
        </div>
    <?php endif; ?>
</main>
<?php require_once '../includes/footer.php'; ?>