<?php
require_once '../includes/header.php';

if (!isset($_SESSION['user_id']) || $_SESSION['role'] !== 'admin') {
    header('Location: /dashboard.php');
    exit;
}

$lesson_id = $_GET['id'] ?? null;
if (!$lesson_id) {
    header('Location: manage_courses.php');
    exit;
}

$stmt_get_lesson = $pdo->prepare("SELECT * FROM lessons WHERE id = ?");
$stmt_get_lesson->execute([$lesson_id]);
$lesson = $stmt_get_lesson->fetch();

if (!$lesson) {
    header('Location: manage_courses.php');
    exit;
}
$course_id_redirect = $lesson['course_id'];

$message = '';
$error = '';

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    check_csrf(); // Verifikasi token keamanan
    
    $title = $_POST['title'];
    $sort_order = $_POST['sort_order'];
    $content = $_POST['content'] ?? $lesson['content']; 

    if (empty($title)) {
        $error = "Judul tidak boleh kosong.";
    } else {
        try {
            $stmt = $pdo->prepare("UPDATE lessons SET title = ?, content = ?, sort_order = ? WHERE id = ?");
            $stmt->execute([$title, $content, $sort_order, $lesson_id]);
            $message = "Materi berhasil diperbarui!";
            
            $stmt_get_lesson->execute([$lesson_id]);
            $lesson = $stmt_get_lesson->fetch();

        } catch (PDOException $e) {
            $error = "Gagal memperbarui materi.";
            error_log($e->getMessage());
        }
    }
}
?>
<main class="container mx-auto p-4 md:p-8">
    <a href="manage_lessons.php?course_id=<?= $course_id_redirect ?>" class="text-blue-500 font-semibold hover:underline mb-6 inline-block">&larr; Kembali ke Kelola Materi</a>
    <h1 class="text-3xl font-bold text-gray-800 mb-8">Edit Materi</h1>

    <?php if ($message): ?><div class="bg-green-100 border border-green-400 text-green-700 px-4 py-3 rounded-lg mb-6"><?= e($message) ?></div><?php endif; ?>
    <?php if ($error): ?><div class="bg-red-100 border-red-400 text-red-700 px-4 py-3 rounded-lg mb-6"><?= e($error) ?></div><?php endif; ?>

    <div class="bg-white p-8 rounded-xl shadow-lg">
        <form action="edit_lesson.php?id=<?= $lesson['id'] ?>" method="POST" class="space-y-4">
            <input type="hidden" name="csrf_token" value="<?= e(generate_csrf_token()); ?>">
            
            <div>
                <label for="sort_order" class="text-sm font-semibold text-gray-600 block">Nomor Urut</label>
                <input type="number" name="sort_order" id="sort_order" value="<?= e($lesson['sort_order']) ?>" class="w-full px-4 py-2 mt-2 border border-gray-300 rounded-lg" required>
            </div>

            <div>
                <label for="title" class="text-sm font-semibold text-gray-600 block">Judul Materi</label>
                <input type="text" name="title" id="title" value="<?= e($lesson['title']) ?>" class="w-full px-4 py-2 mt-2 border border-gray-300 rounded-lg" required>
            </div>
            
            <?php if ($lesson['lesson_type'] === 'text'): ?>
                <div>
                    <label for="content" class="text-sm font-semibold text-gray-600 block">Konten Teks</label>
                    <textarea name="content" id="content" rows="6" class="w-full px-4 py-2 mt-2 border border-gray-300 rounded-lg" required><?= e($lesson['content']) ?></textarea>
                </div>
            <?php else: ?>
                <div class="p-4 bg-gray-100 rounded-lg">
                    <p class="text-sm font-semibold text-gray-600">File Video Saat Ini:</p>
                    <p class="text-gray-800 mt-1"><?= e(basename($lesson['video_path'])) ?></p>
                    <p class="text-xs text-gray-500 mt-2">Fitur untuk mengganti file video belum tersedia. Untuk mengubah video, hapus materi ini dan buat yang baru.</p>
                </div>
            <?php endif; ?>

            <button type="submit" class="px-6 py-3 font-semibold text-white bg-blue-500 rounded-lg hover:bg-blue-600">Simpan Perubahan</button>
        </form>
    </div>
</main>
<?php require_once '../includes/footer.php'; ?>