<?php
require_once '../includes/header.php';
if (!isset($_SESSION['user_id']) || $_SESSION['role'] !== 'admin') { header('Location: /dashboard.php'); exit; }
$course_id = $_GET['id'] ?? null;
if (!$course_id) { header('Location: manage_courses.php'); exit; }
$message = ''; $error = '';
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    check_csrf();
    $title = $_POST['title']; $description = $_POST['description']; $sort_order = $_POST['sort_order']; $price = $_POST['price'];
    if (empty($title)) { $error = "Judul tidak boleh kosong."; } 
    else {
        try {
            $stmt = $pdo->prepare("UPDATE courses SET title = ?, description = ?, sort_order = ?, price = ? WHERE id = ?");
            $stmt->execute([$title, $description, $sort_order, $price, $course_id]);
            $message = "Kursus berhasil diperbarui!";
        } catch (PDOException $e) { $error = "Gagal memperbarui kursus."; error_log($e->getMessage()); }
    }
}
$stmt = $pdo->prepare("SELECT * FROM courses WHERE id = ?"); $stmt->execute([$course_id]); $course = $stmt->fetch();
if (!$course) { header('Location: manage_courses.php'); exit; }
?>
<main class="container mx-auto p-4 md:p-8">
    <a href="manage_courses.php" class="text-blue-500 font-semibold hover:underline mb-6 inline-block">&larr; Kembali ke Kelola Kursus</a>
    <h1 class="text-3xl font-bold text-gray-800 mb-8">Edit Kursus</h1>
    <?php if ($message): ?><div class="bg-green-100 p-4 rounded-lg mb-6 text-green-800"><?= e($message) ?></div><?php endif; ?>
    <?php if ($error): ?><div class="bg-red-100 p-4 rounded-lg mb-6 text-red-800"><?= e($error) ?></div><?php endif; ?>
    <div class="bg-white p-8 rounded-xl shadow-lg">
        <form action="edit_course.php?id=<?= $course['id'] ?>" method="POST" class="space-y-4">
            <input type="hidden" name="csrf_token" value="<?= e(generate_csrf_token()); ?>">
            <div>
                <label for="title" class="text-sm font-semibold text-gray-600 block">Judul Kursus</label>
                <input type="text" name="title" id="title" value="<?= e($course['title']) ?>" class="w-full px-4 py-2 mt-2 border border-gray-300 rounded-lg" required>
            </div>
            <div>
                <label for="description" class="text-sm font-semibold text-gray-600 block">Deskripsi</label>
                <textarea name="description" id="description" rows="4" class="w-full px-4 py-2 mt-2 border border-gray-300 rounded-lg" required><?= e($course['description']) ?></textarea>
            </div>
            <div>
                <label for="price" class="text-sm font-semibold text-gray-600 block">Harga (Rp)</label>
                <input type="number" name="price" id="price" min="0" value="<?= e($course['price']) ?>" class="w-full px-4 py-2 mt-2 border border-gray-300 rounded-lg" required>
            </div>
            <div>
                <label for="sort_order" class="text-sm font-semibold text-gray-600 block">Nomor Urut</label>
                <input type="number" name="sort_order" id="sort_order" min="1" value="<?= e($course['sort_order']) ?>" class="w-full px-4 py-2 mt-2 border border-gray-300 rounded-lg" required>
            </div>
            <button type="submit" class="px-6 py-3 font-semibold text-white bg-blue-500 rounded-lg hover:bg-blue-600">Simpan Perubahan</button>
        </form>
    </div>
</main>
<?php require_once '../includes/footer.php'; ?>